<?php
// routes/api.php

use App\Http\Controllers\Api\AdvisorController;
use App\Http\Controllers\Api\FinderController;
use Illuminate\Support\Facades\Route;

use Illuminate\Http\Request;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Default Sanctum route (optional, keep it)
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::middleware('api.key')->group(function () {
    Route::post('advisor', [AdvisorController::class, 'handle']);
    Route::get('finder', [FinderController::class, 'handle']);
});

Route::get('test', function () {
    return response()->json(['message' => 'API is working!']);
});