<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Dashboard - Car Advisor Gateway</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        .api-key-masked { font-family: monospace; letter-spacing: 1px; }
        .table-hover tbody tr:hover { background-color: rgba(0,0,0,.025); }
    </style>
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
    <div class="container-fluid">
        <a class="navbar-brand" href="{{ route('admin.dashboard') }}">
            <i class="bi bi-shield-lock"></i> Car Advisor Gateway
        </a>
        <div class="d-flex align-items-center">
            <span class="text-light me-3">
                <i class="bi bi-person-circle"></i> {{ auth()->user()->name }}
            </span>
            <form action="{{ route('logout') }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-outline-danger btn-sm">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </button>
            </form>
        </div>
    </div>
</nav>

<div class="container">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 mb-1">Admin Dashboard</h1>
            <p class="text-muted">Monitor usage, manage users and API keys in real time</p>
        </div>
    </div>

    <!-- Stats Cards 
    <div class="row g-4 mb-5">
        <div class="col-md-3 col-sm-6">
            <div class="card border-primary shadow-sm h-100">
                <div class="card-body text-primary">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0">{{ number_format($stats['total_calls_today']) }}</h4>
                            <p class="mb-0">Calls Today</p>
                        </div>
                        <i class="bi bi-graph-up-arrow fs-1 opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="card border-success shadow-sm h-100">
                <div class="card-body text-success">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0">{{ $stats['active_keys'] }}</h4>
                            <p class="mb-0">Active Keys</p>
                        </div>
                        <i class="bi bi-key fs-1 opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="card border-info shadow-sm h-100">
                <div class="card-body text-info">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0">{{ $stats['total_users'] }}</h4>
                            <p class="mb-0">Total Users</p>
                        </div>
                        <i class="bi bi-people fs-1 opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="card border-warning shadow-sm h-100">
                <div class="card-body text-warning">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0">{{ number_format($stats['total_calls']) }}</h4>
                            <p class="mb-0">All-Time Calls</p>
                        </div>
                        <i class="bi bi-activity fs-1 opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    </div> -->
    <div class="row">
        <div class="col-md-3">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5>{{ $stats['total_calls_today'] }}</h5>
                    <p>Calls Today</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5>{{ $stats['active_keys'] }}</h5>
                    <p>Active API Keys</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-info mb-3">
                <div class="card-body">
                    <h5>{{ $stats['total_users'] }}</h5>
                    <p>Total Users</p>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-secondary mb-3">
                <div class="card-body">
                    <h5>{{ number_format($stats['total_calls']) }}</h5>
                    <p>All-Time Calls</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Endpoints -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-bar-chart-line"></i> Top Endpoints (All Time)</h5>
        </div>
        <div class="card-body">
            @if($stats['top_endpoints']->isEmpty())
                <p class="text-muted text-center py-3">No API calls recorded yet.</p>
            @else
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Endpoint</th>
                                <th class="text-end">Total Calls</th>
                                <th class="text-end">Percentage</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($stats['top_endpoints'] as $ep)
                                @php
                                    $percentage = $stats['total_calls'] > 0 
                                        ? round(($ep->count / $stats['total_calls']) * 100, 1) 
                                        : 0;
                                @endphp
                                <tr>
                                    <td><code class="text-primary">/{{ $ep->endpoint }}</code></td>
                                    <td class="text-end fw-bold">{{ number_format($ep->count) }}</td>
                                    <td class="text-end">
                                        <span class="badge bg-{{ $percentage > 50 ? 'danger' : 'secondary' }}">
                                            {{ $percentage }}%
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>

    <!-- User Management Table -->
    <div class="card shadow-sm">
        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-people-fill"></i> User Management</h5>
            <a href="{{ route('admin.logs') }}" class="btn btn-light btn-sm">
                <i class="bi bi-journal-text"></i> View All Logs
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-secondary">
                        <tr>
                            <th>User</th>
                            <th>API Key (masked)</th>
                            <th>Key Name</th>
                            <th>Rate Limit</th>
                            <th>Total Calls</th>
                            <th>Status</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stats['users'] as $user)
                            @php
                                $key = $user->apiKeys->first();
                                $callCount = $key ? $key->apiCallLogs()->count() : 0;
                            @endphp
                            <tr>
                                <td>
                                    <strong>{{ $user->name }}</strong><br>
                                    <small class="text-muted">{{ $user->email }}</small>
                                </td>
                                <td>
                                    @if($key)
                                        <code class="api-key-masked">
                                            {{ Str::mask($key->key, '*', 8, -8) }}
                                        </code>
                                        <!--check if admin and allow toggle eye to display full key-->
                                        
                                            <button class="btn btn-sm btn-outline-secondary ms-2" 
                                                onclick="alert('Full API Key: {{ $key->key }}')">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                        
                                    @else
                                        <span class="text-danger">No key</span>
                                    @endif
                                </td>
                                <td>{{ $key?->name ?? '-' }}</td>
                                <td>
                                    <span class="badge bg-info">
                                        {{ $key?->rate_limit_per_minute ?? 0 }}/min
                                    </span>
                                </td>
                                <td class="text-center fw-bold">{{ number_format($callCount) }}</td>
                                <td>
                                    @if($key && $key->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td class="text-end">
                                    @if($key)
                                        <form action="#" method="POST" class="d-inline">
                                            @csrf
                                            <button type="button" class="btn btn-sm btn-outline-warning" disabled>
                                                <i class="bi bi-slash-circle"></i> Toggle
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @if($stats['users']->isEmpty())
                <p class="text-center text-muted py-4">No users registered yet.</p>
            @endif
        </div>
    </div>
</div>

</body>
</html>