<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\UserApiKey;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // === Create Admin User ===
        $admin = User::updateOrCreate(
            ['email' => 'admin@caradvisor.test'],
            [
                'name' => 'Admin',
                'password' => Hash::make('password'), // Change this in production!
            ]
        );

        // Create one API key for admin (higher rate limit)
        UserApiKey::updateOrCreate(
            ['user_id' => $admin->id],
            [
                'key' => Str::random(40),
                'name' => 'Admin Key',
                'rate_limit_per_minute' => 300,
                'is_active' => true,
            ]
        );

        // === Create Regular Test User ===
        $user = User::updateOrCreate(
            ['email' => 'test@user.com'],
            [
                'name' => 'Test User',
                'password' => Hash::make('test123'),
            ]
        );

        // Create one API key for the test user
        UserApiKey::updateOrCreate(
            ['user_id' => $user->id],
            [
                'key' => Str::random(40),
                'name' => 'My First App Key',
                'rate_limit_per_minute' => 60,
                'is_active' => true,
            ]
        );

        $this->command->info('✅ Users and their API keys have been seeded successfully!');
        $this->command->info('Admin: admin@caradvisor.test / password');
        $this->command->info('Test User: test@user.com / test123');
        $this->command->info('Each user has exactly one API key.');
    }
}