<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\UserApiKey;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run(): void
    {
        // Create admin user
        $admin = User::firstOrCreate(
            ['email' => 'admin@caradvisor.test'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('password'), // change this later!
            ]
        );

        // Create an API key for the admin
        UserApiKey::firstOrCreate(
            ['user_id' => $admin->id, 'name' => 'Admin Master Key'],
            [
                'key' => Str::random(40),
                'name' => 'Admin Master Key',
                'rate_limit_per_minute' => 500, // higher limit for admin
                'is_active' => true,
            ]
        );

        // Optional: Create a test user with API key
        $testUser = User::firstOrCreate(
            ['email' => 'test@user.com'],
            [
                'name' => 'Test User',
                'password' => Hash::make('test123'),
            ]
        );

        UserApiKey::create([
            'user_id' => $testUser->id,
            'key' => Str::random(40),
            'name' => 'Test App Key',
            'rate_limit_per_minute' => 60,
            'is_active' => true,
        ]);

        $this->command->info('Admin user and API keys seeded successfully!');
        $this->command->info('Admin Login: admin@caradvisor.test / password');
    }
}