<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AdvisorController extends Controller
{
    //

    public function handle(Request $request)
    {
        $service = new \App\Services\AwsApiService();
        $awsResponse = $service->proxyRequest('advisor', 'POST', $request->all());

        // Log call
        \App\Models\ApiCallLog::create([
            'user_api_key_id' => $request->api_key_record->id,
            'endpoint' => 'advisor',
            'method' => 'POST',
            'ip_address' => $request->ip(),
            'request_data' => $request->all(),
            'response_code' => $awsResponse['status'],
            'response_time_ms' => $awsResponse['duration_ms'],
        ]);

        return response()->json($awsResponse['body'], $awsResponse['status']);
    }
}
