# Car Advisor Gateway - Laravel API Proxy & Management Dashboard

A secure, production-ready Laravel 11+ application that acts as a **protected gateway** to your AWS SAM-deployed Car Advisor & Finder API.

This Laravel app:
- Proxies requests to your serverless AWS backend
- Enforces **API key authentication**
- Provides **rate limiting** and **full audit logging**
- Includes a **beautiful admin dashboard** for monitoring and user management
- Is ready for **shared hosting** deployment (no Node.js, no Vite)

Live AWS Backend: `https://your-aws-api-id.execute-api.region.amazonaws.com/Prod`

## Features

- **Secure API Key Authentication** (`X-API-KEY` header required)
- **Per-user API keys** with individual rate limits
- **Rate limiting** (default 60 calls/min per key, configurable)
- **Complete request logging** (IP, endpoint, payload, response time, status)
- **Admin Dashboard** with:
  - Real-time stats (calls today, active keys, total users)
  - Top endpoints usage
  - Full user & API key management table (name, email, masked key, calls count, status)
- **Seeder** for instant setup (admin + test user with keys)
- **Plain Bootstrap 5** (CDN) — no build tools, works instantly on localhost & shared hosting
- **Laravel 11+ compatible** (tested on Laravel 12.43.1)

## Endpoints

All endpoints require the `X-API-KEY` header.

| Method | Endpoint                | Description                                   |
|--------|-------------------------|-----------------------------------------------|
| `POST` | `/api/advisor`          | Get price prediction, verdict, and explanation |
| `GET`  | `/api/finder`           | Search and rank car listings by predicted value |

### Example Usage

```bash
# Advisor endpoint
curl -X POST http://127.0.0.1:8000/api/advisor \
  -H "X-API-KEY: your-api-key-here" \
  -H "Content-Type: application/json" \
  -d '{
    "make": "Toyota",
    "model": "Camry",
    "year": 2018,
    "mileage": 80000,
    "offered_price": 8500000,
    "explain_with_openai": false
  }'

# Finder endpoint
curl "http://127.0.0.1:8000/api/finder?make=Toyota&model_q=Camry&max_price=10000000&limit=10" \
  -H "X-API-KEY: your-api-key-here"
```

### Error Responses

- Missing/invalid key → `401 {"error": "API key required"}` or `{"error": "Invalid or expired API key"}`
- Rate limit exceeded → `429 {"error": "Rate limit exceeded"}`

## Admin Dashboard

Access at: `http://yourdomain.com/login`

Default Admin Credentials (from seeder):
- Email: `admin@caradvisor.test`
- Password: `password`

Features:
- Overview stats cards
- Top endpoints table with percentages
- User management table showing:
  - Name & email
  - Masked API key (security)
  - Key name & rate limit
  - Total calls made
  - Active/Inactive status
- Link to full call logs

## Setup & Installation

### 1. Clone or Upload Project

Upload all files to your shared hosting via FTP.

### 2. Environment Configuration (.env)

Copy `.env.example` to `.env` and update:

```env
APP_NAME="Car Advisor Gateway"
APP_ENV=production
APP_KEY=base64:your-generated-key
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_db_user
DB_PASSWORD=your_db_password

# Your AWS SAM API details
AWS_CAR_ADVISOR_API_URL=https://your-api-id.execute-api.us-east-1.amazonaws.com/Prod
AWS_CAR_ADVISOR_API_KEY=your-master-aws-api-key-from-apigateway
```

Generate app key:

```bash
php artisan key:generate
```

### 3. Run Migrations & Seed Data

```bash
php artisan migrate
php artisan db:seed --class=UserSeeder
```

This creates:
- Admin user (`admin@caradvisor.test` / `password`)
- Test user (`test@user.com` / `test123`)
- One API key per user

### 4. Set Permissions (Shared Hosting)

Make these folders writable:
- `storage/`
- `bootstrap/cache/`

Usually `755` or `775`.

### 5. Point Domain to `/public`

In cPanel or hosting panel, set document root to `/public`.

## Project Structure

```
car-advisor-gateway/
├── app/
│   ├── Http/Controllers/Api/        # Proxy controllers
│   ├── Http/Middleware/VerifyApiKey.php
│   ├── Models/UserApiKey.php
│   ├── Models/ApiCallLog.php
│   └── Services/AwsApiService.php
├── routes/
│   ├── api.php                      # Protected endpoints
│   └── web.php                      # Admin login/dashboard
├── resources/views/
│   ├── auth/login.blade.php
│   ├── admin/dashboard.blade.php
│   └── admin/logs.blade.php
├── database/seeders/UserSeeder.php
├── bootstrap/app.php                # Middleware alias registration
├── .env
└── public/
```

## Security Features

- API keys never exposed to clients
- Master AWS key stored in `.env` (server-side only)
- All requests logged with IP and payload
- Rate limiting per key
- Masked keys in admin view
- CSRF protection on web routes
- HTTPS recommended

## Development

```bash
php artisan serve
```

Visit:
- API: `http://127.0.0.1:8000/api/...`
- Admin Login: `http://127.0.0.1:8000/login`

## Deployment Notes for Shared Hosting

- No Node.js or npm required
- No Vite or asset compilation
- Pure PHP + Bootstrap CDN
- Works on PHP 8.2+

## Future Enhancements (Ready to Add)

- User registration & self-service key creation
- API key revocation/disable
- Usage charts per user
- Email notifications on high usage
- Paid tiers / billing

---

**Built with Laravel 11+ • December 2025**

Your secure, monitored gateway to the AI Car Advisor is now complete and ready for production! 🚀

For support or custom features, contact the developer.